---
title: Fixing weird Nextcloud client sync issues
date: 2025-03-07T23:36:41+00:00
draft: true
tags:
  - windows
  - sysadmin
---
Sometimes the Nextcloud client just doesn't work properly. I've had the following error message which can be caused by the client sending files that are too big:
```
Expected filesize of 1680396914 bytes but read (from Nextcloud client) and wrote (to Nextcloud storage) 0 bytes. Could either be a network problem on the sending side or a problem writing to the storage on the server side.
```
Apparently this may be due to the LimitRequestBody apache setting, but I'm gonna do a crazy thing and force the client to chunk. This has helped in the past too when uploading files larger than the PHP memory limit (but apparently the php mem limit doesn't exist on my install anymore?).

Open the nextcloud.cfg file. On Windows, this is stored in `%appdata%\Nextcloud\`.
Add this line under the `[General]` heading:
```ini
maxChunkSize=50000000
```
This sets the max chunk size to 50MB.

If you haven't already changed this on the server, too, now is the time to do that:
```bash
sudo -u www-data php occ config:system:set --type int --value 50000000 files.chunked_upload.max_size
```